//*******************************************************************************************************
//*******************************************************************************************************
//
//      Name:       DebugSc80.C
//      Purpose:    Debug Screen Display (i8021)
//      Author:     Paul Robson
//      Date:       3rd February 2014
//
//*******************************************************************************************************
//*******************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "general.h"
#include "core80.h"
#include "hardware.h"
#include "debugsc80.h"

static void DB80_PrintString(int x,int y,char *text,int fgr);
static void DB80_PrintHex(int x,int y,int n,int fgr,int w);
static int  currentAddress = 0x3C0;

#include "mnemonics11.h"

//*******************************************************************************************************
//                                      Draw the debugger screen
//*******************************************************************************************************

void DB80_Draw()
{
    char *labels[] = { "A","X","Y","XY","M","ST","LS","CL","SL",
                        "CA","PA","PC","CB","CS","PB","SR","","BP",NULL };
    int i = 0;
    while (labels[i] != NULL)
    {
        DB80_PrintString(12+(i/9)*6,i % 9,labels[i],2);
        i++;
    }
    C80_STATUS *s = C80_GetStatus(NULL);
    //DB80_PrintHex(15,0,s->a,3,2);
}

//*******************************************************************************************************
//                                          Print a string
//*******************************************************************************************************

static void DB80_PrintString(int x,int y,char *text,int fgr)
{
    while (*text != '\0')
    {
        IF_Write(x++,y,*text++,fgr);
    }
}

//*******************************************************************************************************
//                                  Print a hexadecimal constant
//*******************************************************************************************************

static void DB80_PrintHex(int x,int y,int n,int fgr,int w)
{
    char buffer[8];
    sprintf(buffer,"%0*x",w,n);
    DB80_PrintString(x,y,buffer,fgr);
}

//*******************************************************************************************************
//                                          Set Display Address
//*******************************************************************************************************

void DB80_SetAddress(int addr) {
    currentAddress = addr;
}

//*******************************************************************************************************
//                                          Get Display Address
//*******************************************************************************************************

int DB80_GetAddress() {
    return currentAddress;
}

//*******************************************************************************************************
//                                      Shift digit into current address
//*******************************************************************************************************

void DB80_UpdateAddress(int digit) {
    currentAddress = ((currentAddress << 4) | digit) & 0x7FF;
}
